<?php
	Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl.'/js/admin/main.js');
	Yii::app()->clientScript->registerScript('game', <<<SCRIPT

		$("#addNewAnswer").click(function(){
			var maxAnswerId = -1;
			$('#answersContainer').find('div').each(function(){
				if($(this).attr('answerId')!=undefined && parseInt($(this).attr('answerId')) > maxAnswerId)
					maxAnswerId = $(this).attr('answerId');
			});
			var newAnswerId = parseInt(maxAnswerId)+1;


			var answersCount = 1;
			$("#answersContainer").find('label').each(function(){
				answersCount++;
			});

			var answerInput = '<div answerId="'+newAnswerId+'">\
								<label for="ZlecenieOdpowiedz_'+newAnswerId+'_odpowiedz"># '+answersCount+'</label>\
								<input name="ZlecenieOdpowiedz['+newAnswerId+'][odpowiedz]" id="ZlecenieOdpowiedz_'+newAnswerId+'_odpowiedz" type="text"> | <a href="#" class="buttonS bRed removeAnswer">Usuń</a>\
							</div>';
			$("#answersContainer").append(answerInput);
			return false;
		});

		$('.form').on('click', '.removeAnswer',function(){
				$(this).parent().remove();
				var i = 1;
				$("#answersContainer").find('label').each(function(){
					$(this).text('#'+i);
					i++;
				});
				return false;
		});

		initTimeField($('#Zlecenie_czas'));
		$('#zlecenie-form').submit(function(){
			serializeTimeField($('#Zlecenie_czas'));
		});

SCRIPT
, CClientScript::POS_READY);

?>
<div class="form">

<?php $form=$this->beginWidget('CActiveForm', array(
	'id'=>'zlecenie-form',
	'enableAjaxValidation'=>false,
	'htmlOptions'=>array('enctype'=>'multipart/form-data')
)); ?>

	<div class="row">
		<?php echo $form->labelEx($model,'moodle'); ?>
		<?php echo $form->checkbox($model,'moodle'); ?>
		<?php echo $form->error($model,'moodle'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'wylaczone'); ?>
		<?php echo $form->dropDownList($model,'wylaczone', array(''=>'Nie', '1'=>'Tak')); ?>
		<?php echo $form->error($model,'wylaczone'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'idDziedziny'); ?>
		<?php echo $form->dropDownList($model,'idDziedziny',array(''=>'Wybierz dziedzinę')+CHtml::listData(Dziedzina::model()->findAll('"id" NOT IN (5,6)'),'id','nazwa')); ?>
		<?php echo $form->error($model,'idDziedziny'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'kategoria'); ?>
		<?php echo $form->textField($model,'kategoria',array('size'=>60,'maxlength'=>64)); ?>
		<?php echo $form->error($model,'kategoria'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'tresc'); ?>
		<?php echo $form->textArea($model,'tresc',array('size'=>60,'maxlength'=>4000, 'cols'=>50, 'rows'=>15)); ?>
		<?php echo $form->error($model,'tresc'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'poziom'); ?>
		<?php echo $form->dropDownList($model,'poziom', array(''=>'Wybierz poziom') + Zlecenie::getPoziomArray()); ?>
		<?php echo $form->error($model,'poziom'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'czas'); ?>
		<?php echo $form->textField($model,'czas'); ?>
		<?php echo $form->error($model,'czas'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'cena'); ?>
		<?php echo $form->textField($model,'cena'); ?>
		<?php echo $form->error($model,'cena'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'kara'); ?>
		<?php echo $form->textField($model,'kara'); ?>
		<?php echo $form->error($model,'kara'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'czyPrzetarg'); ?>
		<?php echo $form->checkbox($model,'czyPrzetarg'); ?>
		<?php echo $form->error($model,'czyPrzetarg'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'czyEgzamin'); ?>
		<?php echo $form->checkbox($model,'czyEgzamin'); ?>
		<?php echo $form->error($model,'czyEgzamin'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'jezyk'); ?>
		<?php echo $form->dropDownList($model,'jezyk',array(''=>'brak','en'=>'Angielski')); ?>
		<?php echo $form->error($model,'jezyk'); ?>
	</div>

	<div class="row">
		<?php echo $form->labelEx($model,'image'); ?>
		<?php if($this->action->id=='create' && !empty($model->tempImageName)): ?>
			<img id="uploadedImage" src="<?php echo Yii::app()->baseUrl ?>/uploads/temp/<?php echo $model->tempFolderName ?>/<?php echo $model->tempImageName ?>" />
		<?php elseif($this->action->id=='update' && !empty($model->urlObrazka)): ?>
			<img id="uploadedImage" src="<?php echo Yii::app()->baseUrl ?>/<?php echo $model->urlObrazka ?>" />
		<?php endif; ?>
		<?php echo $form->fileField($model, 'image', array('onchange'=>'$("#uploadedImage").remove();')); ?>
		<?php echo $form->error($model,'image'); ?>
	</div>

	<?php if($this->action->id=='create' && !empty($model->tempFolderName)): ?>
		<?php echo CHtml::activeHiddenField($model, 'tempFolderName') ?>
		<?php echo CHtml::activeHiddenField($model, 'tempImageName') ?>
	<?php else: ?>
		<?php echo CHtml::activeHiddenField($model, 'urlObrazka') ?>
	<?php endif; ?>

	<div class="row">
		<?php echo $form->labelEx($model,'jednostka'); ?>
		<?php echo $form->textField($model,'jednostka'); ?>
		<?php echo $form->error($model,'jednostka'); ?>
	</div>

	<div class="row">
		<fieldset>
			<legend><label>Odpowiedzi</label></legend>
			<div id="answersContainer">
				<?php foreach($orderAnswers as $i=>$answer): ?>
					<div answerId="<?php echo $i ?>">
						<label for="ZlecenieOdpowiedz_<?php echo $i ?>_odpowiedz">#<?php echo $i+1 ?></label>
						<?php echo $form->textField($answer,'['.$i.']odpowiedz'); ?>
						<?php echo $form->error($answer,'['.$i.']odpowiedz'); ?>
						| <a href="#" class="removeAnswer buttonS bRed">Usuń</a>
					</div>
				<?php endforeach; ?>
			</div>
			<button id="addNewAnswer" class="buttonS bBlue">Dodaj nową odpowiedź</button>
		</fieldset>
	</div>

	<div class="row buttons">
		<?php echo CHtml::submitButton($model->isNewRecord ? 'Utwórz' : 'Zapisz', array('class' => 'buttonS bBlue')); ?>
	</div>

<?php $this->endWidget(); ?>

</div>
